/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.entity.Button;
import com.work4games.entity.Mouse;
import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Content;
import com.work4games.handlers.Keys;
import com.work4games.main.Game;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class MenuState
extends GameState {
    private Mouse mouse;
    private ArrayList<Button> buttons;
    protected double rotation = 0.2;
    protected double angle = 90.0;

    public MenuState(GameStateManager gsm) {
        this.gsm = gsm;
        this.init();
    }

    @Override
    public void init() {
        this.mouse = new Mouse();
        this.buttons = new ArrayList();
        PlayerSave.setTimeLimit(0.0);
        Button b = new Button(14, "ADVENTURE", 180, 44, 320, 230, true);
        this.buttons.add(b);
        Button b1 = new Button(14, "TIME ATTACK", 180, 44, 320, 280, true);
        this.buttons.add(b1);
        Button b2 = new Button(14, "OPTIONS", 180, 44, 320, 330, true);
        this.buttons.add(b2);
        Button b3 = new Button(14, "QUIT", 180, 44, 320, 380, true);
        this.buttons.add(b3);
    }

    @Override
    public void update() {
        this.handleInput();
        int i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            b.update();
            if (b.intersects(this.mouse)) {
                b.setHover(true);
                if (this.mouse.getClicked()) {
                    if (b.getButtonID() == "ADVENTURE") {
                        this.gsm.setState(3);
                    } else if (b.getButtonID() == "TIME ATTACK") {
                        this.gsm.setState(2);
                    } else if (b.getButtonID() == "OPTIONS") {
                        System.out.println("Options");
                    } else if (b.getButtonID() == "QUIT") {
                        Game.loading = true;
                        System.exit(0);
                    }
                }
            } else {
                b.setHover(false);
            }
            ++i;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.Title, 320 - Content.Title.getWidth() / 2, 50, null);
        g.setColor(Color.WHITE);
        g.setFont(this.gsm.pixelFont14);
        int i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            b.draw(g);
            ++i;
        }
        this.mouse.draw(g);
    }

    @Override
    public void handleInput() {
        this.mouse.update();
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            Game.loading = true;
            System.exit(0);
        }
        if (Keys.isKeyPressed(Keys.W)) {
            PlayerSave.setMap("/Maps/Test2.map");
            PlayerSave.setMode(1);
            PlayerSave.setTimeLimit(0.0);
            this.gsm.setState(1);
        }
    }
}

